/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.memory;

import emulator.EmulatorException;
import emulator.hardware.memory.DebugMemoryBlock;
import emulator.hardware.memory.UnmappedMemoryException;
import org.junit.Assert;
import org.junit.Test;

public class DebugMemoryBlockTest {
    @Test
    public void testDebugMemoryBlockReadFirst() throws EmulatorException {
        DebugMemoryBlock memory = new DebugMemoryBlock(4096);
        Assert.assertEquals((long)0L, (long)memory.read(0));
    }

    @Test
    public void testDebugMemoryBlockReadLast() throws EmulatorException {
        DebugMemoryBlock memory = new DebugMemoryBlock(4096);
        Assert.assertEquals((long)0L, (long)memory.read(4095));
    }

    @Test(expected=UnmappedMemoryException.class)
    public void testDebugMemoryBlockReadOver() throws EmulatorException {
        DebugMemoryBlock memory = new DebugMemoryBlock(4096);
        memory.read(4096);
    }

    @Test
    public void testDebugMemoryBlockReadBackFirst() throws EmulatorException {
        DebugMemoryBlock memory = new DebugMemoryBlock(4096);
        memory.write(0, 85);
        Assert.assertEquals((long)85L, (long)memory.read(0));
    }

    @Test
    public void testDebugMemoryBlockReadBackLast() throws EmulatorException {
        DebugMemoryBlock memory = new DebugMemoryBlock(4096);
        memory.write(4095, 85);
        Assert.assertEquals((long)85L, (long)memory.read(4095));
    }

    @Test(expected=UnmappedMemoryException.class)
    public void testDebugMemoryBlockWriteOver() throws EmulatorException {
        DebugMemoryBlock memory = new DebugMemoryBlock(4096);
        memory.write(4096, 85);
    }
}

